class Stack
{
    // innere Klasse fuer Listenelemente
    static class Node
    {
        public Node(Object d, Node n)
        {
            data = d;
            link = n;
        }

        Object data;

        Node link;
    }

    private Node topRef = null;

    public synchronized void push(Object elem)
    {
        topRef = new Node(elem, topRef);
    }

    public synchronized void pop()
    {
        if (topRef != null)
            topRef = topRef.link;
    }

    public synchronized Object top()
    {
        if (topRef != null)
            return topRef.data;
        else
            return null;
    }

    public boolean empty()
    {
        return topRef == null;
    }
}

class StackUser extends Thread
{
    private Stack myStack;

    private int rounds, delay, ident;

    public StackUser(Stack st, int rd, int del, int id)

    {
        myStack = st;
        rounds = rd;
        delay = del;
        ident = id;
    }

    public void run()
    {
        for (int r = 0; r < rounds; r++)
        {
            String elem = String.valueOf(r * 100 + ident);

            myStack.push(elem);

            System.out.println("push " + elem);

            try
            {
                sleep(delay);
            }
            catch (InterruptedException e)
            {
            }

        }

        for (int r = 0; r < rounds; r++)
        {
            if (!myStack.empty())
            {
                System.out.println("pop  " + (String) myStack.top());

                myStack.pop();
            }

            try
            {
                sleep(delay);
            }
            catch (InterruptedException e) {}
        }
    }
}

class StackExample
{
    public static void main(String[] args)
    {

        Stack s = new Stack();

        StackUser u1 = new StackUser(s, 5, 300, 1);

        StackUser u2 = new StackUser(s, 5, 500, 2);

        u1.start();
        u2.start();

    }
}
